    // Model 9. Public capital
    // Dynare Code
    // File: model9.mod
    // Jos L. Torres. University of Mlaga (Spain)
    // Endogenous variables
    var Y, C, I, K, IZ, Z, L, W, R, A, B;
    // Exogenous variables
    varexo e, u, tauc, taul, tauk;
    // Parameters
    parameters alpha, alpha1, alpha2, alpha3, beta, deltak, deltag, gamma, rho1, rho2;
    // Calibrated parameters
    alpha  = 0.35;
    alpha1 = 0.315;
    alpha2 = 0.100;
    alpha3 = 0.585;
    beta   = 0.97;
    deltak = 0.06;
    deltag = 0.02;
    gamma  = 0.40;
    rho1   = 0.95;
    rho2   = 0.95;
    // Equations of the model economy
    model;
    (1+tauc)*C=(gamma/(1-gamma))*(1-L)*(1-taul)*(1-alpha)*Y/L;
    1 = beta*((((1+tauc)*C)/((1+tauc)*C(+1)))
     *((1-tauk)*alpha*Y(+1)/K+(1-deltak)));
    Y = A*(K(-1)^alpha1)*(Z(-1)^alpha2)*(L^alpha3);
    K = (Y-C)+(1-deltak)*K(-1);
    Z = IZ+(1-deltag)*Z(-1);
    I = Y-C-IZ;
    IZ = B*0.05*Y;
    W = (1-alpha)*A*(K(-1)^alpha1)*(Z(-1)^alpha2)*(L^(alpha3-1));
    R = alpha*A*(K(-1)^(alpha1-1))*(Z(-1)^alpha2)*(L^(alpha3));
    log(A) = rho1*log(A(-1))+e;
    log(B) = rho2*log(B(-1))+u;
    end;
    // Initial values
    initval;
    Y = 1; 
    C = 0.75;
    L = 0.3;
    K = 3.5;
    I = 0.25;
    Z = 1;
    IZ = 0.05*Y;
    W = (1-alpha)*Y/L;
    R = alpha*Y/K;
    A = 1;
    B = 1;
    e = 0;
    u = 0;
    tauc = 0.116;
    tauk = 0.225;
    taul = 0.344;
    end;
    // Steady state
    steady;
    // Blanchard-Kahn conditions
    check;
    // Disturbance analysis
    shocks;
    var u; stderr 0.01;
    end;
    // Stochastic simulation
    stoch_simul;