% ***********************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% The Solow-Swan growth model in MATLAB
% File: m9.m
% *********************************************
clear all
% Periods
T       =   100;
% Exogenous variables
A       =   1.00;
s       =   0.20;
% Parameters calibration
Alpha   =   0.35;
Delta   =   0.06;
n       =   0.02;
% Initial Steady State
kbar    =	((n+Delta)/(s*A))^(1/(Alpha-1));
ybar	=	A*kbar^Alpha;
cbar    =	ybar-(n+Delta)*kbar;
ibar    =	(n+Delta)*kbar;
% Disturbances
s       =   0.25;
%n       =   0.01;
% New Steady State
kbar1    =   ((n+Delta)/(s*A))^(1/(Alpha-1));
ybar1	 =	 A*kbar1^Alpha;
cbar1    =   ybar1-(n+Delta)*kbar1;
ibar1    =   (n+Delta)*kbar1;
% Dynamics
k(1)=kbar;
for i=1:T-1;
    k(i+1)  =   ((1-Delta)*k(i)+s*A*k(i)^Alpha)/(1+n);
end;
% Variables
y       =   A*k.^Alpha;
c       =   (1-s)*y;
% Growth rate
gy(1)   =   0;
for i=2:T;
    gy(i)  =   100*(y(i)-y(i-1))/y(i-1);
end;
% Graphics
j=1:T;
subplot(2,2,1)
plot(j,(y-ybar)./ybar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Output per capita','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(2,2,2)
plot(j,(k-kbar)/kbar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Capital stock per capita','FontName','Times')
subplot(2,2,3)
plot(j,(c-cbar)/cbar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Consumption per capita','FontName','Times')
subplot(2,2,4)
plot(j,gy,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Per capita output growth rate','FontName','Times')
