%************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Basic Dynamic General Equilibrium model
% Utility function: U=ln(C)
% Technology: Y=A*L^alpha
% File: m8foc.m. Script file: m8.m
%************************************************
function f=m8foc(z,par)
% Parameters loading
load par
Ass     =   par(1);
Alpha   =   par(2);
Delta   =   par(3);
Rho     =   par(4);
Beta    =   par(5);
Kss     =   par(6);
T       =   par(7);
for i=1:T;
A(i)    =   par(7+i);
end;
% Assigment of variables
for t=1:T
C(t) = z(t);
K(t) = z(t+T);
end
C(T+1) = C(T);
K0=Kss;
% Equation to solve
f(1)    =   C(2)-Beta*(Alpha*A(1)*K(1)^(Alpha-1)+(1-Delta))*C(1);
f(2)    =   C(1)+K(1)-(1-Delta)*K0-A(1)*K0^Alpha;
for t=2:T
f(2*t-1)    =   C(t+1)-Beta*(Alpha*A(t)*K(t)^(Alpha-1)+(1-Delta))*C(t);
f(2*t)      =   C(t)+K(t)-(1-Delta)*K(t-1)-A(t)*K(t-1)^Alpha;
end    