// ***********************************************
// An Introduction to Computational Macroeconomics
// A. Bongers, T. Gmez and J. L. Torres (2019)
// Basic DSGE model in DYNARE
// File: m8d.mod
// ***********************************************
// Endogenous variables
var Y, C, I, K, R, A;
// Exogenous variables
varexo e;
// Parameters
parameters alpha, beta, delta, rho;
// Calibration
alpha = 0.35;
beta  = 0.96;
delta = 0.06;
rho   = 0.80;
// Defining capital stock as predetermined variable
predetermined_variables K;
// Model equations
model;
1     = beta*((C/C(+1))*(R(+1)+(1-delta)));
Y     = A*K^alpha;
K(+1) = (1-delta)*K+I;
Y     = C+I;
R     = alpha*A*K^(alpha-1);
A     = A(-1)^rho+e;
end;
// Initial (guess) values
initval;
Y = 1; 
C = 0.8; 
K = 3.5;
I = 0.2;
R = alpha*Y/K;
A = 1;
e = 0;
end;
// Steady State
steady;
// Stability conditions
check;
ybar=oo_.steady_state(1);
cbar=oo_.steady_state(2);
ibar=oo_.steady_state(3);
kbar=oo_.steady_state(4);
Rbar=oo_.steady_state(5);
Abar=oo_.steady_state(6);
// Disturbances
shocks;
var e;
stderr 0.01;
end;
// Solution
stoch_simul(order=1);
% Graphics
figure;
T=40;
j=1:T;
subplot(2,2,1)
plot(j,Y_e+ybar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Output','FontName','Times')
subplot(2,2,2)
plot(j,K_e+kbar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Capital stock','FontName','Times')
subplot(2,2,3)
plot(j,C_e+cbar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Consumption','FontName','Times')
subplot(2,2,4)
plot(j,I_e+ibar,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Investment','FontName','Times')