// ***********************************************
// An Introduction to Computational Macroeconomics
// A. Bongers, T. Gmez and J. L. Torres (2019)
// The Tobin's Q model in DYNARE
// File: m7d.mod
// ***********************************************
// Endogenous variables
var q k dq dk;
// Exogenous variables
varexo R, delta;
// Parameters
parameters alpha, phi;
// Calibration
alpha   =   0.35;
phi     =   10;
// Defining capital stock as predetermined (state) variable
predetermined_variables k; 
// Model equations
model;
(1-delta)*q(+1)=(1+R)*q-alpha*k(+1)^(alpha-1)+phi/2*(((k(+2)-k(+1))/k(+1)))^2-phi*((k(+2)-k(+1))/k(+1))*(k(+2)-(1-delta)*k(+1))/k(+1);
k(+1)-k=(q-1)*k/phi;
dk=k(+1)-k;
dq=q(+1)-q;
end;
// Initial (guess) values
initval;
q      =    1;
k      =    10;
dk     =    0;
dq     =    0;
R      =    0.04;
delta  =    0.06;
end;
// Initial Steady State
steady;
check;
// Final (guess) values
// Disturbance: Decrease in the interest rate
endval;
q      =    1;
k      =    10;
dk     =    0;
dq     =    0;
R      =    0.03;
delta  =    0.06;
end;
// New Steady State
steady;
// Stability conditions
check;
// Deterministic solution
simul(periods=200);
// Graphics
T=60;
j=1:T;
subplot(1,2,1)
plot(j,q(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('q ratio','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(1,2,2)
plot(j,k(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Capital stock','FontName','Times')
xlabel('Periods','FontName','Times')
