%**************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Distortionary taxes
% Utility function: U=gamma*ln(C)+(1-gamma)*log(1-L)
% File: m6.m. Associated function: m6foc.m
%***************************************************
clear all
% Parameters
T       =   30;     % Household's lifespan
beta    =   0.97; 	% Discount factor
gamma   =   0.40;   % Consumption weight in the utility function
% Exogenous variables
R       =   0.05; 	% Real interest rate
tauw    =   0.35;   % Labor income tax rate
taur    =   0.25;   % Capital income tax rate
tauc    =   0.15;   % Consumption tax rate
for t=1:T;
    W(t)    =   100; % Salary
end
par	=	[T beta R gamma tauw taur tauc W];
save par par;
% Initial (guess) values
x0	=	[10*ones(size(1:T)), 0.3*ones(size(1:T))]';
% Algorithm
sol	=	fsolve('m6foc', x0);
% Solution
for t=1:T
    	C(t)	=	sol(t);
        L(t)    =   sol(t+T);
end

for t=2:T;
	B(1)    =   (1-tauw)*W(1)*L(1)-(1+tauc)*C(1);
    B(t)    =   (1+(1-taur)*R)*B(t-1)+(1-tauw)*W(t)*L(t)-(1+tauc)*C(t);
   % G(t) = tauc*C(t)+tauw*W(t)*L(t)+taur*R*B(t-1);
end
%Permanent change in tax rates
tauw1    =   0.35;
taur1    =   0.30;
tauc1    =   0.15;
par	=	[T beta R gamma tauw1 taur1 tauc1 W];
save par par;
% Initial (guess) values
x0	=	[10*ones(size(1:T)), 0.3*ones(size(1:T))]';
% Algorithm
sol	=	fsolve('m6foc', x0);
% Solution
for t=1:T
    	C1(t)	 =	 sol(t);
        L1(t)    =   sol(t+T);
end
W1=W;
for t=2:T;
	B1(1)    =   (1-tauw1)*W(1)*L1(1)-(1+tauc1)*C1(1);
    B1(t)    =   (1+(1-taur1)*R)*B1(t-1)+(1-tauw1)*W(t)*L1(t)-(1+tauc1)*C1(t);
end
% Graphics
i=1:T;
subplot(2,2,1)
plot(i,C,'--',i,C1,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Consumption','FontName','Times')
subplot(2,2,2)
plot(i,B,'--',i,B1,'-','Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Saving (Stock of financial assets)','FontName','Times')
subplot(2,2,3)
plot(i,(1-tauw).*W.*L,'--',i,(1-tauw1).*W1.*L1,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Labor income (net of labor income tax)','FontName','Times')
subplot(2,2,4)
plot(i,L,'--',i,L1,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Labor (fraction of time)','FontName','Times')
