% ***********************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% The consumption-saving decision
% Logaritmic utility function: U=ln(C)
% File: m4.m. Auxiliary function: m4foc.m
% ***********************************************
clear all
% Parameters
T       =   30;         % Lifespan
beta    =   0.97;       % Discount factor
% Exogenous variables
R       =   0.02;       % Interst rate
for t=1:T;
    W(t)    =   10; 	% Salary
end
par	=	[T beta R W];
save par par;
% Initial values
x0	=	10*ones(size(1:T))'; 
% Calling fsolve
sol	=	fsolve('m4foc',x0);
% Solution
for t=1:T
    C(t)	=	sol(t);
end
for t=2:T;
	B(1) =	W(1)-C(1);
	B(t) =	(1+R)*B(t-1)+W(t)-C(t);
end
for t=1:T
	U(t)	=	beta^t*log(C(t));
end
% Figures
subplot(2,2,1)
plot(C,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Consumption','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(2,2,2)
plot(B,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Saving','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(2,2,3)
plot(W,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Income','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(2,2,4)
plot(U,'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Discounted utility','FontName','Times')
xlabel('Periods','FontName','Times')
