% ***********************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (20198)
% Exhange rate overshooting model in DYNARE
% File: m3d.mod
% ***********************************************
// Endogenous variables
var p s yd i dp ds;
// Exogenous variables
varexo m, beta0, ypot, pstar, istar;
// Parameters
parameters psi, theta, beta1, beta2, mi;
// Calibration
theta   =   0.5;
psi     =   0.05;
beta1   =   20;
beta2   =   0.1;
mi      =   0.01;
// The model
model;
 m-p=psi*ypot-theta*i;
 yd=beta0+beta1*(s-p+pstar)-beta2*i;
 dp=mi*(yd-ypot);
 ds=i-istar;
 dp(-1)=p-p(-1);
 ds=s(+1)-s;
end;
// Initial values
initval;
 yd      =    ypot;
 p       =    1;
 s       =    10;
 i       =    3;
 dp      =    0;
 ds      =    0;
 m       =    100;
 beta0   =    500;
 ypot    =    2000;
 pstar   =    0;
 istar   =    3;
end;
// Initial Steady State
steady;
check;
// Final values
endval;
 yd      =    ypot;
 p       =    1;
 s       =    10;
 i       =    3;
 dp      =    0;
 ds      =    0;
 m       =    101;
 beta0   =    500;
 ypot    =    2000;
 pstar   =    0;
 istar   =    3;
end;
// Final Steady State
steady;
// Shock analysis
shocks;
 var m;
 periods 0;
 values 0;
end;
// Numerical solution
simul(periods=30);
// Graphics
T=15;
j=1:T;
subplot(2,2,1)
plot(j,s(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Nominal exchange rate','FontName','Times')
subplot(2,2,2)
plot(j,yd(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Aggregate demand','FontName','Times')
subplot(2,2,3)
plot(j,p(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Prices','FontName','Times')
subplot(2,2,4)
plot(j,i(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Nominal interest rate','FontName','Times')
