%************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Basic Dynamic General Equilibrium model
% Utility function: U=ln(C)
% Technology: Y=A*L^alpha
% File: m8.m. Associated function: m8foc.m
%************************************************
clear all
% Periods
T   =   100;
% Parameters calibration
Ass     = 1.00;  
Alpha   = 0.35;
Delta   = 0.06;
Rho     = 0.80;
Beta    = 0.96;
% Steady State
Kss =   ((1-Beta+Delta*Beta)/(Ass*Alpha*Beta))^(1/(Alpha-1));
Yss =   Ass*Kss^Alpha;
Iss =   Delta*Kss;
Css =   Yss-Iss;
% Pertubation
Epsilon=0.01;
A(1)=Ass^Rho+Epsilon;
 for i=2:T;
   A(i)=A(i-1)^Rho;
 end
par =[Ass Alpha Delta Rho Beta Kss T A];
save par par;
% Initial (guess) values
x0  =   [Kss*ones(size(1:T)) 0.20*Kss*ones(size(1:T))]';
% Algorithm
sol =   fsolve('m8foc',x0);
% Solution
 for t=1:T;
  C(t) = sol(t);
  K(t) = sol(t+T);
 end
Y = A.*K.^Alpha;
K(T+1)=K(T);
I = K(2:T+1)-(1-Delta)*K(1:T);
T=60;
% Graphics
subplot(2,2,1)
plot((C(1:T)-Css)/Css,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Consumption','FontName','Times')
subplot(2,2,2)
plot((K(1:T)-Kss)/Kss,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Capital stock','FontName','Times')
subplot(2,2,3)
plot((Y(1:T)-Yss)/Yss,'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Output','FontName','Times')
subplot(2,2,4)
plot(A(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
xlabel('Periods','FontName','Times')
title('Total Factor Productivity','FontName','Times')
