%**************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% Distortionary taxes
% Utility function: U=gamma*ln(C)+(1-gamma)*log(1-L)
% File: m6foc.m. Script file: m6.m
%***************************************************
function f=m6foc(x0, par)
% Carga de parmetros
load par
T       =   par(1);
beta    =   par(2);
R       =   par(3);
gamma   =   par(4);
tauw    =   par(5);
taur    =   par(6);
tauc    =   par(7);
for i=1:T;
W(i)    =   par(7+i);
end;
% Asignacion de variables
for t=1:T
    C(t)    =   x0(t);
    L(t)    =   x0(t+T);
end
% Clculo del ahorro
for t=2:T;
B(1)    =   (1-tauw)*W(1)*L(1)-(1+tauc)*C(1);
B(t)    =   (1+(1-taur)*R)*B(t-1)+(1-tauw)*W(t)*L(t)-(1+tauc)*C(t);
end
% Senda ptima de consumo   
f(1)            =   (1+tauc)*C(2)-beta*(1+(1-taur)*R)*(1+tauc)*C(1);
f(2)            =   (1-tauw)*W(1)*(1-L(1))-((1+tauc)*C(1))*(1-gamma)/gamma;
for t=2:T-1
    f(2*t-1)    =   (1+tauc)*C(t+1)-beta*(1+(1-taur)*R)*(1+tauc)*C(t);
    f(2*t)      =   (1-tauw)*W(t)*(1-L(t))-((1+tauc)*C(t))*(1-gamma)/gamma;
end
f(2*T-1)          =   (1+tauc)*C(T)-(1+(1-taur)*R)*B(T-1)-(1-tauw)*W(T)*L(T);
f(2*T)            =   (1-tauw)*W(T)*(1-L(T))-((1+tauc)*C(T))*(1-gamma)/gamma;




