% ************************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% The consumption-saving decision
% Logarithmic utility function: U=ln(C)
% Function File: m4foc.m. Script file: m4.m
% ************************************************
function f=m4foc(x0,par)
% Loading parameters
load par
T       =   par(1);
beta    =   par(2);
R       =   par(3);
for i=1:T;
W(i)    =   par(3+i);
end;
% Variables assignment
for t=1:T
    C(t)    =   x0(t);
end
% Saving
for t=2:T-1;
B(1)    =   W(1)-C(1);
B(t)    =   (1+R)*B(t-1)+W(t)-C(t);
end
% Consumption optimal path   
f(1)        =   C(2)-beta*(1+R)*C(1);
for t=2:T-1
    f(2*t-1)    =   C(t+1)-beta*(1+R)*C(t);
end
f(T)        =   C(T)-W(T)-(1+R)*B(T-1);

