% ***********************************************
% An Introduction to Computational Macroeconomics
% A. Bongers, T. Gmez and J. L. Torres (2019)
% An example of a dynamic system in DYNARE
% Richardson's arms race model
% File: m1d.mod
% ***********************************************
// Endogenous variables
var x1 x2 dx1 dx2;
// Exogenous variables
varexo z1 z2;
// Parameters
parameters Alpha, Beta, Gamma, Delta, Theta, Ita;
Alpha   =   0.25;
Beta    =   0.50;
Gamma   =   0.50;
Delta   =   0.25;
Theta   =   1.00;
Ita     =   1.00;
// Model equations
model(linear);
 x1(+1) = x1+dx1;
 x2     = x2(-1)+dx2(-1); 
 dx1    = -Alpha*x1+Beta*x2+Theta*z1;
 dx2    = Gamma*x1-Delta*x2+Ita*z2;
end;
// Initial values
initval;
 x1      = 4;
 x2      = 4;
 dx1     = 0;
 dx2     = 0;
 z1      = -1;
 z2      = -1;
end;
// Initial Steady State
steady;
check;
// Final values
endval;
 x1      = 4;
 x2      = 4;
 dx1     = 0;
 dx2     = 0;
 z1      = -0.5;
 z2      = -1;
end;
// Final Steady State
steady;
// Shocks analysis
shocks;
 var z1;
 periods 0;
 values 0;
end;
// Deterministic simulation
simul(periods=30);
// Grficos
T=30;
j=1:T;
figure;
subplot(1,2,1)
plot(j,x1(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Armament stock. Country 1','FontName','Times')
xlabel('Periods','FontName','Times')
subplot(1,2,2)
plot(j,x2(1:T),'Color',[0.25 0.25 0.25],'linewidth',3.5)
title('Armament stock. Country 2','FontName','Times')
xlabel('Periods','FontName','Times')

